package conversions;
import java.util.*;

public class QuantityContainer {
	private Vector v = new Vector();
	
	public static void main(String args[]) {
		QuantityContainer qc = new QuantityContainer();
		qc.addQuantity(new LengthQuantity(
			120, "Length of car", Quantity.GLOBAL_GEOMETRY_TYPE));
		qc.addQuantity(new AccelerationQuantity(
			1.7, "car acceleration", Quantity.GLOBAL_GEOMETRY_TYPE));
		qc.addQuantity(new MassQuantity(
			5000, "car mass", Quantity.GLOBAL_GEOMETRY_TYPE));
		
		qc.print();
		qc.convertToMetric();
		qc.print();

	}
	public void print() {
		ObservableQuantity qa[] = getQuantities();
		for (int i=0; i < qa.length; i++) 
			System.out.println(qa[i]);
	}
	public void addQuantity(ObservableQuantity q) {
		v.addElement(q);
	}
	public int getSize() {
		return v.size();
	}
	public void convertToMetric() {
		for (int i=0; i < getSize(); i++) {
			((Quantity)v.elementAt(i)).convertToMetric();
		}		
	}
	public void convertToEnglish() {
		for (int i=0; i < getSize(); i++) {
			((Quantity)v.elementAt(i)).convertToEnglish();
		}		
	}
	/**
		support the type prop for queries.
	*/
	public ObservableQuantity[] getQuantities(int type) {
		Vector typeVector = new Vector();
		for (int i=0; i < getSize(); i++) {
			ObservableQuantity q = (ObservableQuantity)v.elementAt(i);
			if (q.getType() == type) 
				typeVector.addElement(q);
		}
		ObservableQuantity qa[] = new ObservableQuantity[typeVector.size()];
		for (int i=0; i < getSize(); i++) {
			qa[i] = (ObservableQuantity)typeVector.elementAt(i);
		}
		return qa;
	}
	
	/**
		get all the Quantities.
	*/
	public ObservableQuantity[] getQuantities() {
		ObservableQuantity qa[] = new ObservableQuantity[getSize()];
		for (int i=0; i < getSize(); i++) {
			qa[i] = (ObservableQuantity)v.elementAt(i);
		}
		return qa;
	}
}